/* Registers common to each mode */
#define HST_MODE          0x00
#define RESET_DETECT      0x01
#define HST_COMMAND       0x02
#define ERROR_STATUS_LOW  0xFE
#define ERROR_STATUS_HIGH 0xFF
/* HST_MODE Fields */
/*---------------- */
#define MODE_MASK                     0x8F

/* HST_MODE Requests */
#define RESET                         0x01
#define DEEP_SLEEP                    0x02
#define SET_LOW_POWER_ENABLE          0x04
#define MODE_CHANGE_REQUEST           0x08

/* Device Modes */
#define OPERATING_MODE                0x00
#define SYSTEM_INFORMATION_MODE       0x10
#define CONFIGURATION_AND_TEST_MODE   0x20
#define BOOTLOADER_MODE               0x40  /* Not defined in the docs as this, used for reporting the mode correctly */
#define DATA_TOGGLE                   0x80

#define DEVICE_MODE_MASK              0x70

#define MODE_CHANGE_SWITCH            0x08

/* Reset Detect */
#define RESET_OCCURRED                0x01

#define COMMON_COMMAND_OFFSET         0x02
#define COMMON_COMMAND_DATA_OFFSET    0x03

#define COMMAND_COMPLETE                         (1 << 6)
#define CONTROLLER_COMPLETED_COMMAND             (1 << 7) // 'Toggle' in the docs

/* Error Status */
#define ERROR_WATCH_DOG_TIMER         (1 << 0)
/* Reserved */
#define ERROR_VDDA_LOW_VOLATAGE       (1 << 2)
#define ERROR_CONFIG_CRC              (1 << 3)
#define ERROR_BOOTLOADER_CRC          (1 << 4)
#define ERROR_APPLICATION_CRC         (1 << 5)
#define ERROR_INVALID_CONFIG          (1 << 6)
#define ERROR_AUTO_SHORT_TEST         (1 << 7)
#define ERROR_OPEN_CIRCUIT_TEST	      (1 << 8)

/* Error return status */
#define ERROR_RECOVERABLE             0
#define ERROR_NON_RECOVERABLE         1

#define LOW_BYTE(n)   ((uint8_t)((n) & 0xFF))
#define HIGH_BYTE(n)   ((uint8_t)(LOW_BYTE((n) >> 8)))


#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/common.h $ $Rev: 886397 $")
#endif
